package com.hero.objects.skills;

import java.util.ArrayList;

import org.jdom.Element;

import com.hero.HeroDesigner;
import com.hero.objects.Adder;
import com.hero.objects.GenericObject;
import com.hero.objects.enhancers.Enhancer;

/**
 * Copyright (c) 2000 - 2005, CompNet Design, Inc. All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, is prohibited unless the following conditions are met: 1.
 * Express written consent of CompNet Design, Inc. is obtained by the developer.
 * 2. Redistributions must retain this copyright notice. THIS SOFTWARE IS
 * PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * @author CompNet Design, Inc.
 * @version $Revision$
 */

public class Gambling extends Skill {

	private static String xmlID = "GAMBLING";

	public Gambling(Element template) {
		super(template, Gambling.xmlID);
	}

	@Override
	public double getTotalCost() {
		enhancerApplied = null;
		if (isEveryman()) {
			return 0;
		}
		double total = getBaseCost();
		if (getAssignedAdders().size() == 0) {
			if (isFamiliarity()) {
				total = 1;
			} else if (isProficiency()) {
				total = proficiencyCost;
			} else if (levelsOnly()) {
				total = 0;
			} else {
				total = 3;
			}
		}
		if (getLevelValue() != 0) {
			double bd = getLevels() / getLevelValue() * getLevelCost();
			total += bd;
			if ((getLevels() > 0)
					&& HeroDesigner.getActiveHero().getRules()
							.getUseSkillMaxima() && rollBased) {
				int limit = HeroDesigner.getActiveHero().getRules()
						.getSkillMaximaLimit();
				int roll = getRollValue();
				int sec = getSecondaryRollValue();
				if (sec > roll) {
					roll = sec;
				}
				if (roll > limit) {
					int expensive = roll - limit;
					if (expensive > getLevels()) {
						expensive = getLevels();
					}
					total += expensive / getLevelValue() * getLevelCost();
				}
			}
		}
		int count = -1;
		for (Adder ad : getAssignedAdders()) {
			count++;
			if (ad.getRealCost() > 0) {
				if ((count == 0) && (isFamiliarity() || isProficiency())
						&& (ad.getMinimumCost() < ad.getRealCost())) {
					total += ad.getMinimumCost();
				} else {
					total += ad.getRealCost();
				}
			}
		}
		if ((total < getMinimumCost()) && isMinSet()) {
			total = getMinimumCost();
		} else if ((total > getMaxCost()) && isMaxSet()) {
			total = getMaxCost();
		}
		for (Adder ad : getAssignedAdders()) {
			if (ad.getRealCost() < 0) {
				total += ad.getRealCost();
			}
		}

		if ((getTypes() != null) && (getTypes().size() > 0) && !levelsOnly()) {
			ArrayList<GenericObject> enhancers = HeroDesigner.getActiveHero()
					.getSkills();
			OUTER: for (GenericObject o : enhancers) {
				if (o instanceof Enhancer) {
					Enhancer enhancer = (Enhancer) o;
					for (String s : getTypes()) {
						if (enhancer.appliesToType(s)) {
							enhancerApplied = enhancer;
							// just take the first match and leave it at
							// that...
							if (total > enhancer.getCostSavings()) {
								total -= enhancer.getCostSavings();
							} else if (total > 0) {
								total = 1;
							}
							break OUTER;
						}
					}
				}
			}
		}
		return total;
	}

	@Override
	public boolean includeFamiliarity() {
		return true;
	}
}